#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Programme pour comprendre quelques fonctions dans Python dans le but
de construire un programme de transcription et traduction de l'ADN.

Ce programme est un exemple de codage permettant 
de traduire des mots français en mots aliens.
Pour utiliser le programme, il faut le lancer dans la console d'exécution 
puis appeler la fonction traduction avec la phrase "BONJOUR LE MONDE"
à traduire :
Ecrire : traduction ("BONJOUR LE MONDE")

@auteur: Sébastien LECOT Sebastien.Lecot1@ac-rennes.fr
"""
#Code et explications du code

#Il s'agit dans un 1er temps de créer le dictionnaire traduisant
#les mots français en mots aliens.
#Dans Python, un dictionnaire constitue un moyen de stocker
#de l'information. A chaque entrée dans le dictionnaire correspondra
#une sortie. Ici, à chaque mot français correspondra un mot alien.
#Un dictionnaire se note de la façon suivante: 
#mon_dictionnaire = {"entrée1":"sortie1, "entrée2":"sortie2", ...}
dico_français_alien = {"bonjour":"kodar", "le":"tzoum", "monde":"vorag"}
                       
#La suite du programmme va permettre de traduire les mots français
#en mots aliens.

def transcription (phraseFrançais): #définition de la 1ère fonction
    #Fonction qui permet de passer les lettres capitales en minuscules
    motsFrançais = "" #séquence vide au début de l'exécution du programme.
    #Elle sera construite sous la forme d'une chaine de caractères
    #en lettres minuscules
    for i in range (len(phraseFrançais)): #Pour chaque caractère 
        #sur la longueur de la phrase,
        if phraseFrançais[i] == "B": #Si le caractère est "B"
            motsFrançais = motsFrançais + "b" #Ajouter "b" 
            #dans la chaine de caractères "motsFrançais"
        elif phraseFrançais[i] == "D":
            motsFrançais = motsFrançais + "d"
        elif phraseFrançais[i] == "E":
            motsFrançais = motsFrançais + "e"
        elif phraseFrançais[i] == "J":
            motsFrançais = motsFrançais + "j"
        elif phraseFrançais[i] == "L":
            motsFrançais = motsFrançais + "l"
        elif phraseFrançais[i] == "M":
            motsFrançais = motsFrançais + "m"
        elif phraseFrançais[i] == "N":
            motsFrançais = motsFrançais + "n"
        elif phraseFrançais[i] == "O":
            motsFrançais = motsFrançais + "o"
        elif phraseFrançais[i] == "R":
            motsFrançais = motsFrançais + "r"
        elif phraseFrançais[i] == "U":
            motsFrançais = motsFrançais + "u"
        else:
            motsFrançais = motsFrançais + " " #Si aucun caractère, 
            #ajouter un espace
    return motsFrançais #Envoyer la phrase en minuscules 
                        #à la suite du programme

def traduction (phraseFrançais):#définition de la 2ème fonction
    #Fonction qui permet de traduire les mots français en mots extraterrestres
    motsFrançais = transcription (phraseFrançais) #Exécuter 
    #la fonction transcription à phrase en Français entrée par l'utilisateur
    #La séquence de mots Français envoyée est une chaine de caractères
    listeFrançais = motsFrançais.split() #Tranforme la chaîne de caractères 
    #motFrançais en liste où chaque mot est un élément de la liste
    phraseAlien = [] #phrase alien vide au début de l'exécution du programme
    #Elle sera construite sous la forme d'une liste
    for mot in listeFrançais: #Pour chaque mot dans la liste
        if mot in dico_français_alien: #Si le mot est 
            #dans le dictionnaire
            phraseAlien.append(dico_français_alien[mot]) #Ajouter le mot 
            #correspondant dans la liste phraseAlien
        else: #Si le mot n'est pas dans le dictionnaire
            print ("Ma phrase est =", motsFrançais) 
            #Afficher la phrase en minuscules
            print ("En alien, on dit:", " ".join(phraseAlien))
            #Envoyer la phrase alien qui s'affichera
            #dans la console d'exécution du programme
            return 
    print ("Ma phrase est =", motsFrançais) 
    #Afficher la phrase en minuscules
    print ("En alien, on dit:", " ".join(phraseAlien))
    #Envoyer la phrase alien qui s'affichera
    #dans la console d'exécution du programme
    return
    
